<?php
include 'db.php'; // Include your database connection file

// Get the order_id from the URL (GET method)
$order_id = $_GET['id'] ?? null;

if (!$order_id) {
    echo json_encode(["status" => "error", "message" => "order ID is required"]);
    exit;
}

// Validate and fetch the order
$order_query = "
    SELECT * FROM orders 
    WHERE Order_id = '$order_id' AND Delete_status = 0
";
$order_result = mysqli_query($conn, $order_query);

if (!$order_result || mysqli_num_rows($order_result) == 0) {
    echo json_encode(["status" => "error", "message" => "order not found or you do not have permission to convert this order"]);
    exit;
}

$order = mysqli_fetch_assoc($order_result);

$order_data_query = "
    SELECT * FROM order_data 
    WHERE Order_id = '$order_id' AND Delete_status = 0
";
$order_data_result = mysqli_query($conn, $order_data_query);

if (!$order_data_result || mysqli_num_rows($order_data_result) == 0) {
    echo json_encode(["status" => "error", "message" => "No products found in this order"]);
    exit;
}

$order_data = [];
while ($row = mysqli_fetch_assoc($order_data_result)) {
    $order_data[] = $row;
}

// Generate a unique invoice number
$invoice_no_query = "SELECT MAX(invoice_id) AS max_id FROM invoice";
$invoice_no_result = mysqli_query($conn, $invoice_no_query);
$max_id = mysqli_fetch_assoc($invoice_no_result)['max_id'] ?? 0;
$invoice_no = "INV-" . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);

// Start transaction for atomic operations
mysqli_begin_transaction($conn);

try {
    // First update the order status
    $update_order_query = "
        UPDATE orders 
        SET Action_status = 1, Editor_id = '$user_id' 
        WHERE Order_id = '$order_id'
    ";
    if (!mysqli_query($conn, $update_order_query)) {
        throw new Exception("Failed to update order status");
    }

    // Insert into the invoice table
    $created_date = date('Y-m-d H:i:s');
    $invoice_query = "
        INSERT INTO invoice (
            order_id, Invoice_no, user_id, displayname, Balance, Created_date, Tax, Tax_percentage, Discount, Discount_percentage, 
            Shipping, Roundoff, Total_saving, Total_price, No_of_items, Total_discount, Grand_total, Action_status, Store_status,
            Created_id, Editor_id, Delete_status,prebooked
        ) VALUES (
            '$order_id', '$invoice_no', '{$order['user_id']}', '{$order['displayname']}', '{$order['Grand_total']}', '$created_date', '{$order['Tax']}', '{$order['Tax_percentage']}', '{$order['Discount']}', 
            '{$order['Discount_percentage']}', '{$order['Shipping']}', '{$order['Roundoff']}', '{$order['Total_saving']}', 
            '{$order['Total_price']}', '{$order['No_of_items']}', '{$order['Total_discount']}', '{$order['Grand_total']}', 7, 0,
            '{$order['Created_id']}', '{$order['Editor_id']}', 0,1
        )
    ";

    if (!mysqli_query($conn, $invoice_query)) {
        throw new Exception("Failed to create invoice");
    }
    $invoice_id = mysqli_insert_id($conn);
//     $invoice_payment = "
//     UPDATE payment
//     SET Invoice_id = '$invoice_id'
//     WHERE Order_id = '$order_id'
// ";

// // Execute the query
// if (!mysqli_query($conn, $invoice_payment)) {
//     throw new Exception("Failed to update payment records: " . mysqli_error($conn));
// }

    // Insert invoice data
    foreach ($order_data as $product) {
        $invoice_data_query = "
            INSERT INTO invoice_data (
                invoice_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
                Tax_percentage, Tax, Product_total, Delete_status
            ) VALUES (
                '$invoice_id', '{$product['Product_id']}', '{$product['qty']}', '{$product['Selling_price']}', '{$product['MRP']}', 
                '{$product['discount']}', '{$product['Discount_percentage']}', '{$product['Tax_percentage']}', '{$product['Tax']}', 
                '{$product['Product_total']}', 0
            )
        ";
        if (!mysqli_query($conn, $invoice_data_query)) {
            throw new Exception("Failed to insert invoice data");
        }

        // Update product and inventory quantities
        $update_product_query = "
            UPDATE product 
            SET qty = qty - '{$product['qty']}' 
            WHERE Product_id = '{$product['Product_id']}'
        ";
        if (!mysqli_query($conn, $update_product_query)) {
            throw new Exception("Failed to update product quantity");
        }

        $update_inventory_query = "
            UPDATE inventory  
            SET Qty = Qty - '{$product['qty']}',
            date_modified = NOW()
            WHERE Product_id = '{$product['Product_id']}'
        ";
        if (!mysqli_query($conn, $update_inventory_query)) {
            throw new Exception("Failed to update inventory");
        }
    }

    // Insert invoice PDF details
    $querys = mysqli_query($conn, "SELECT * FROM user_profile WHERE User_id = 4");
    if (!$querys) {
        throw new Exception("Error fetching profile data: " . mysqli_error($conn));
    }

    $profileselect = mysqli_fetch_array($querys);

    // Assign profile data with defaults
    $storename = $profileselect['store_name'] ?? 'Default Store Name';
    $email = $profileselect['Email'] ?? 'no-reply@example.com';
    $street1 = $profileselect['Address'] ?? '';
    $street2 = $profileselect['street2'] ?? '';
    $city = $profileselect['City'] ?? '';
    $state = $profileselect['State'] ?? '';
    $pincode = $profileselect['Pincode'] ?? '';
    $phonenumber = $profileselect['Phone'] ?? '';
    $gstno = $profileselect['gstin'] ?? '';
    $logopath = $profileselect['store_image'] ?? '';
    $accountno = $profileselect['acount_no'] ?? '';
    $ifsc = $profileselect['ifsc'] ?? '';
    $bank = $profileselect['bank_name'] ?? '';
    $upiid = $profileselect['upiid'] ?? '';

    // Fetch invoice information
    $query = mysqli_query($conn, "SELECT i.invoice_id, i.invoice_no, i.Created_date, i.Grand_total, i.Shipping, 
                                 c.displayname, c.phoneno, c.address, c.address2, c.city, c.pincode, c.gstno, c.email, 
                                 i.order_id, i.user_id
                                 FROM invoice i 
                                 INNER JOIN customer c ON c.id = i.user_id 
                                 WHERE i.invoice_id = '$invoice_id'");

    if (!$query) {
        throw new Exception("Error fetching invoice data: " . mysqli_error($conn));
    }

    $invoice = mysqli_fetch_array($query);
    $grandtotal11 = $invoice['Grand_total'];
    $shipping = $invoice['Shipping'];
    $invoice_data = $invoice['Created_date'];

    // Fetch invoice settings
    $query1 = mysqli_query($conn, "SELECT * FROM invoicesetting WHERE 1");
    if (!$query1) {
        throw new Exception("Error fetching invoice settings: " . mysqli_error($conn));
    }
    $terms = mysqli_fetch_array($query1);

    $sqlInsert = "INSERT INTO invoicepdfdetails 
                 (invoiceno, invoiceid, orderid, customerid, totalsavings, shipping, grandtotal, 
                  storename, email, street1, street2, city, state, pincode, phonenumber, gstnumber, 
                  logopath, notes, account, ifsc, bankname, displayname, phoneno, address, address2, 
                  customer_city, customer_pincode, customer_gstno, customer_email, upiid, terms, qrcode) 
                 VALUES 
                 ('$invoice_no', '$invoice_id', '$order_id', '{$order['user_id']}', '{$order['Total_saving']}', 
                  '$shipping', '$grandtotal11', '$storename', '$email', '$street1', '$street2', '$city', 
                  '$state', '$pincode', '$phonenumber', '$gstno', '$logopath', '" . mysqli_real_escape_string($conn, $terms['note']) . "', 
                  '$accountno', '$ifsc', '$bank', '" . mysqli_real_escape_string($conn, $invoice['displayname']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['phoneno']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['address']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['address2']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['city']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['pincode']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['gstno']) . "', 
                  '" . mysqli_real_escape_string($conn, $invoice['email']) . "', 
                  '$upiid', '" . mysqli_real_escape_string($conn, $terms['terms']) . "', 
                  '" . mysqli_real_escape_string($conn, $terms['qrcode']) . "')";

    if (!mysqli_query($conn, $sqlInsert)) {
        throw new Exception("Error inserting invoice PDF details: " . mysqli_error($conn));
    }

    // Commit transaction if all queries succeeded
    mysqli_commit($conn);

    echo json_encode([
        "status" => "success",
        "message" => "order converted to invoice successfully",
        "invoice_id" => $invoice_id
    ]);
    header("Location: https://hapitest.xyz/hapi%20bilzs%20sts/admin/invoices.php");
    exit;

} catch (Exception $e) {
    // Rollback transaction on error
    mysqli_rollback($conn);
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
    exit;
}
?>